package com.logicbig.example;

import org.junit.jupiter.api.*;
import org.junit.jupiter.api.extension.ExtendWith;
import java.io.IOException;

@ExtendWith(MyLifecycleExceptionHandler.class)
public class LifecycleHandlerTest {

    @BeforeEach
    void setup() throws IOException {
        System.out.println("Running @BeforeEach setup...");
        // This would normally crash the whole test
        throw new IOException("Failed to write transient test log");
    }

    @Test
    void importantTest() {
        System.out.println("  Executing core test logic...");
        Assertions.assertTrue(true);
    }

    @AfterEach
    void cleanup() {
        System.out.println("Running @AfterEach cleanup...");
        throw new UnsupportedOperationException("Cleanup not implemented yet");
    }
}