package com.logicbig.example;

import org.junit.jupiter.api.extension.*;

public class PerformanceExtension implements BeforeTestExecutionCallback, AfterTestExecutionCallback {
    private static final String START_TIME = "START_TIME";

    @Override
    public void beforeTestExecution(ExtensionContext context) {
        context.getStore(ExtensionContext.Namespace.create(getClass(), context.getRequiredTestMethod()))
               .put(START_TIME, System.currentTimeMillis());
    }

    @Override
    public void afterTestExecution(ExtensionContext context) {
        long startTime = context.getStore(ExtensionContext.Namespace.create(getClass(), context.getRequiredTestMethod()))
                                .remove(START_TIME, long.class);
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("Performance: " + context.getDisplayName() + " took " + duration + "ms");
    }
}