package com.logicbig.example;

import org.junit.jupiter.api.extension.*;

public class PageInjectionExtension implements ParameterResolver {
    @Override
    public boolean supportsParameter(ParameterContext pc, ExtensionContext ec) {
        return pc.isAnnotated(Uri.class) && pc.getParameter().getType() == Page.class;
    }

    @Override
    public Object resolveParameter(ParameterContext pc, ExtensionContext ec) {
        String path = pc.findAnnotation(Uri.class).get().value();
        //simulate finding Page from the backend
        return new Page(path, "Content of " + path);
    }
}