package com.logicbig.example;

import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import java.util.stream.Stream;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.DynamicContainer.dynamicContainer;
import static org.junit.jupiter.api.DynamicTest.dynamicTest;

public class HierarchicalDynamicNodeTest {

    @TestFactory
    Stream<DynamicContainer> dynamicNodeHierarchy() {
        return Stream
                .of("Node A", "Node B")
                .map(HierarchicalDynamicNodeTest::getMainDynamicContainer);
    }

    private static DynamicContainer getMainDynamicContainer(String input) {
        return dynamicContainer("Container for " + input,
                                createDynamicNodeStream(input));
    }

    private static Stream<DynamicNode> createDynamicNodeStream(String input) {
        return Stream.of(
                dynamicTest("test not null",
                            () -> assertNotNull(input)),
                dynamicContainer("Sub-container",
                                 createAnotherDynamicTest(input))
        );
    }

    private static Stream<DynamicTest> createAnotherDynamicTest(String input) {
        return Stream.of(
                dynamicTest("test length",
                            () -> assertTrue(!input.isEmpty()))
        );
    }
}