package com.logicbig.example;

import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import java.util.Arrays;
import java.util.stream.Stream;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.DynamicContainer.dynamicContainer;
import static org.junit.jupiter.api.DynamicTest.dynamicTest;

public class DynamicContainerTest {

    @TestFactory
    Stream<DynamicContainer> dynamicContainerExample() {
        return Stream.
                of("math", "logic")
                .map(DynamicContainerTest::createMainDynamicContainer);
    }

    private static DynamicContainer createMainDynamicContainer(String topic) {
        return dynamicContainer("Topic: " + topic,
                                Arrays.asList(
                                        getDynamicTest(topic),
                                        getAnotherDynamicTest(topic)
                                ));
    }

    private static DynamicTest getAnotherDynamicTest(String topic) {
        return dynamicTest(topic + " test 2",
                           () -> assertEquals(4, 2 + 2));
    }

    private static DynamicTest getDynamicTest(String topic) {
        return dynamicTest(topic + " test 1",
                           () -> assertTrue(true));
    }
}