package com.logicbig.example;

 // Mock service class for dependency injection demonstration
public class MockService {
    private final String name;
    private final String id;
    private boolean active;

    public MockService(String name) {
        this.name = name;
        this.id = "SVC-" + System.currentTimeMillis();
        this.active = true;
        System.out.println("[SERVICE] Created: " + name + " (ID: " + id + ")");
    }

    public String getName() {return name;}

    public String getId() {return id;}

    public boolean isActive() {return active;}

    public void execute(String operation) {
        if (active) {
            System.out.println("[SERVICE] Executing: " + operation + " on " + name);
        }
    }

    public void cleanup() {
        active = false;
        System.out.println("[SERVICE] Cleaned up: " + name);
    }
}