package com.logicbig.example;

import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;


public class MyReportListener implements TestExecutionListener {

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier,
                                        ReportEntry entry) {

        System.out.println(
            "[REPORT-ENTRY-LISTENER] " +
            testIdentifier.getDisplayName() +
            " -> " +
            entry.getKeyValuePairs()
        );
    }

    @Override
    public void fileEntryPublished(TestIdentifier testIdentifier,
                                   FileEntry fileEntry) {

        System.out.println(
                "[REPORT-FILE-ENTRY-LISTENER] " +
                        testIdentifier.getDisplayName() +
                        " -> " +
                        fileEntry.toString()
        );
    }
}