package com.logicbig.example;

import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(MetadataAwareExtension.class)
public class MetadataExtensionTest {
    
    @Test
    @Tag("fast")
    void fastTest() {
        System.out.println("Executing fastTest");
    }
    
    @Test
    @Tag("slow")
    @Tag("integration")
    @AuditLog(level = "DEBUG", category = "database")
    void slowIntegrationTest() {
        System.out.println("Executing slowIntegrationTest");
        try {
            Thread.sleep(100); // Simulate slow operation
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
    
    @Test
    @Tag("security")
    @Tag("integration")
    @AuditLog(level = "AUDIT", category = "security", trackArguments = true)
    void securityIntegrationTest() {
        System.out.println("Executing securityIntegrationTest");
        // Simulate security check
        String sensitiveData = "password123";
        System.out.println("Processing sensitive operation");
    }
    
    @Test
    @Tag("fast")
    @AuditLog // Uses default values
    void fastTestWithAudit() {
        System.out.println("Executing fastTestWithAudit");
    }
}