package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith({PolicyInvocationExtension.class, PolicyIdParameterResolver.class})
public class PolicyDrivenTest {
    
    // This method will be invoked by the extension using ExecutableInvoker
    void verifyPolicy(TestInfo testInfo, @PolicyId String id) {
        System.out.println("[VERIFY] Policy " + id +
                         " verified for " + testInfo.getDisplayName());
        
        // Simulate policy validation logic
        if (!id.startsWith("POLICY-")) {
            throw new SecurityException("Invalid policy ID format: " + id);
        }
        
        System.out.println("[VERIFY] Policy validation passed");
    }
    
    @Test
    void businessTest() {
        System.out.println("[TEST] Executing actual business test logic");
        // Actual test logic would go here
        int result = processBusinessLogic(10, 20);
        System.out.println("[TEST] Business logic result: " + result);
    }
    
    @Test
    void anotherBusinessTest() {
        System.out.println("[TEST] Executing another business test");
        String data = transformData("input");
        System.out.println("[TEST] Transformed data: " + data);
    }
    
    private int processBusinessLogic(int a, int b) {
        return a * b; // Simulated business logic
    }
    
    private String transformData(String input) {
        return input.toUpperCase() + "-processed";
    }
}