package com.logicbig.example;

import org.junit.jupiter.api.extension.*;
import java.util.List;

public class HierarchyAwareExtension implements BeforeEachCallback, BeforeAllCallback {

    @Override
    public void beforeAll(ExtensionContext context) {
        System.out.println("\n=== BEFORE ALL ===");
        printContextInfo("Class Level", context);
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        System.out.println("\n=== BEFORE EACH ===");
        printContextInfo("Method Level", context);

        // Show parent hierarchy
        showParentHierarchy(context);

        // Show enclosing classes hierarchy
        showEnclosingClasses(context);

        // Show hierarchy depth
        int depth = calculateHierarchyDepth(context);
        System.out.println("Hierarchy Depth: " + depth);
    }

    private void printContextInfo(String phase, ExtensionContext context) {
        System.out.println("Phase: " + phase);
        System.out.println("Display Name: " + context.getDisplayName());
        System.out.println("Unique ID: " + context.getUniqueId());
        System.out.println("---");
    }

    private void showParentHierarchy(ExtensionContext context) {
        System.out.println("Parent Hierarchy:");
        System.out.println("  Current -> " + context.getDisplayName());

        ExtensionContext current = context;
        int level = 1;
        while (current.getParent().isPresent()) {
            current = current.getParent().get();
            System.out.println("  Parent Level " + level + " -> " + current.getDisplayName());
            level++;
        }

        System.out.println("  Root -> " + context.getRoot().getDisplayName());
    }

    private void showEnclosingClasses(ExtensionContext context) {
        List<Class<?>> enclosingClasses = context.getEnclosingTestClasses();
        if (!enclosingClasses.isEmpty()) {
            System.out.println("Enclosing Classes (outermost to innermost):");
            for (int i = 0; i < enclosingClasses.size(); i++) {
                System.out.println("  Level " + i + ": " + enclosingClasses.get(i).getSimpleName());
            }
        } else {
            System.out.println("No enclosing classes (top-level test)");
        }
    }

    private int calculateHierarchyDepth(ExtensionContext context) {
        int depth = 0;
        ExtensionContext current = context;

        while (current.getParent().isPresent()) {
            depth++;
            current = current.getParent().get();
        }

        return depth;
    }
}