package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith({
    OrderTestInstanceFactory.class,
    OrderIdParameterResolver.class
})
public class OrderTest {
    private final String orderId;
    
    public OrderTest(@OrderId String orderId) {
        this.orderId = orderId;
        System.out.println("[CONSTRUCTOR] OrderTest instance created");
        System.out.println("[CONSTRUCTOR] Order ID: " + orderId);
        System.out.println("[CONSTRUCTOR] Instance: " + this.getClass().getSimpleName() + 
                         "@" + System.identityHashCode(this));
    }
    
    @Test
    void testOrderCreation() {
        System.out.println("[TEST] Running testOrderCreation with orderId = " + orderId);
        
        // Simulate order validation logic
        if (!orderId.startsWith("ORDER-")) {
            throw new IllegalArgumentException("Invalid order ID format: " + orderId);
        }
        
        System.out.println("[TEST] Order validation passed");
        
        // Simulate business logic
        String orderStatus = processOrder(orderId);
        System.out.println("[TEST] Order status: " + orderStatus);
    }
    
    @Test
    void testOrderProcessing() {
        System.out.println("[TEST] Running testOrderProcessing with orderId = " + orderId);
        
        // Demonstrate that the same instance is used for both tests in PER_CLASS lifecycle
        System.out.println("[TEST] Instance reference: " + System.identityHashCode(this));
        
        // Simulate order processing logic
        double total = calculateOrderTotal(2, 49.99);
        System.out.println("[TEST] Order total: $" + total);
    }
    
    private String processOrder(String orderId) {
        return "PROCESSED-" + orderId;
    }
    
    private double calculateOrderTotal(int quantity, double price) {
        return quantity * price;
    }
}