package com.logicbig.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;

@TestInstance(TestInstance.Lifecycle.PER_METHOD)
@ExtendWith({
    OrderTestInstanceFactory.class,
    OrderIdParameterResolver.class
})
public class MultiInstanceTest {
    private final String orderId;
    private static int instanceCounter = 0;
    
    public MultiInstanceTest(@OrderId String orderId) {
        this.orderId = orderId;
        instanceCounter++;
        System.out.println("[CONSTRUCTOR] MultiInstanceTest instance #" + instanceCounter);
        System.out.println("[CONSTRUCTOR] Unique order ID: " + orderId);
    }
    
    @Test
    void firstTest() {
        System.out.println("[TEST] First test executing with orderId = " + orderId);
        System.out.println("[TEST] Instance count: " + instanceCounter);
        
        // Each test method gets a new instance with PER_METHOD lifecycle
        // Each instance has a unique order ID
        validateOrderId(orderId);
    }
    
    @Test
    void secondTest() {
        System.out.println("[TEST] Second test executing with orderId = " + orderId);
        System.out.println("[TEST] Instance count: " + instanceCounter);
        
        // This is a different instance with a different order ID
        validateOrderId(orderId);
        
        // Simulate different business logic
        if (orderId.contains("ORDER")) {
            System.out.println("[TEST] Order ID format verified");
        }
    }
    
    private void validateOrderId(String orderId) {
        if (orderId == null || orderId.length() < 10) {
            throw new IllegalArgumentException("Invalid order ID: " + orderId);
        }
        System.out.println("[TEST] Order ID validation passed");
    }
}