package com.logicbig.example;

import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class IgnoreTestCondition implements ExecutionCondition {
    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        RepeatedTest repeatedTest = context.getElement().get().getAnnotation(RepeatedTest.class);
        if (repeatedTest != null) {
            return ConditionEvaluationResult.disabled("Repeated tests are disabled");
        }else{
            return ConditionEvaluationResult.enabled("All other tests are allowed");
        }
    }
}