package com.logicbig.example;

import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.TestFactory;
import java.util.stream.Stream;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.DynamicTest.dynamicTest;

public class DynamicTestsNamedTest {

    @TestFactory
    Stream<DynamicTest> dynamicTestsWithNamed() {
        return Stream.of(
                Named.of("Small prime", 7),
                Named.of("Large even number", 100),
                Named.of("Minimum positive integer", 1)
        ).map(named -> dynamicTest(named.getName(), () -> {
            Integer value = named.getPayload();
            System.out.println("Testing value: " + value);
            assertTrue(value > 0);
        }));
    }
}