package com.logicbig.example;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.NamedExecutable;
import org.junit.jupiter.api.TestFactory;
import java.util.stream.Stream;

public class NamedExecutableTest {

    @TestFactory
    Stream<DynamicTest> dynamicTests() {
        return DynamicTest.stream(Stream.of(
                new MathTask(5, 5, 10),
                new MathTask(20, 30, 50),
                new MathTask(100, 1, 101)
        ));
    }

    /**
     * A record implementing NamedExecutable bundles the
     * display name and the test logic together.
     */
    record MathTask(int n1, int n2, int expected) implements NamedExecutable {

        @Override
        public void execute() {
            System.out.println("Checking " + n1 + " + " + n2);
            Assertions.assertEquals(expected, n1 + n2);
        }

        @Override
        public String getName() {
            return "Sum Test: " + n1 + " + " + n2 + " = " + expected;
        }
    }
}