package com.logicbig.example;

import org.junit.jupiter.api.*;
import org.junit.jupiter.api.function.Executable;
import java.util.Map;
import java.util.stream.Stream;


class DynamicTestsLifecycleTest {

    @BeforeAll
    static void beforeAll(){
        System.out.println("before all main");
    }

    @AfterAll
    static void afterAll(){
        System.out.println("after all main");
    }

    @BeforeEach
    void beforeEach(){
        System.out.println("before each main");
    }

    @AfterEach
    void afterEach(){
        System.out.println("after each main");
    }

    @Test
    void normalTest(){
        System.out.println("normal test");
    }

    @TestFactory
    Stream<DynamicTest> dataDrivenTests() {
        Map<String, String> data = loadDynamicData();
        return data.entrySet()
                   .stream()
                   .map(DynamicTestsLifecycleTest::toDynamicTest);
    }

    private static DynamicTest toDynamicTest(Map.Entry<String, String> data) {
        return DynamicTest.dynamicTest(data.getKey(),
                                       new MyTestExecutable(data));
    }


    private static class MyTestExecutable implements Executable {
        private final String name;
        private final String data;

        public MyTestExecutable(Map.Entry<String, String> entry) {
            name = entry.getKey();
            data = entry.getValue();
        }

        @Override
        public void execute() {
            //@BeforeEach workaround
            setup();
            //performing test
            performTest();
            //@AfterEach workaround
            teardown();
        }

        private void setup() {
            System.out.println("setting up dynamic test: " + name);
        }

        private void performTest() {
            System.out.println("Performing dynamic test: " + name);
            Assertions.assertEquals(3, data.length());
        }

        private void teardown() {
            System.out.println("tearing down dynamic test: "+name);
        }
    }

    private static Map<String, String> loadDynamicData() {
        //simulate loading data dynamically
        return Map.of("A", "one", "B", "two");
    }
}