package com.logicbig.example;

import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import java.util.Map;
import java.util.stream.Stream;
import static org.junit.jupiter.api.Assertions.assertEquals;

public class DynamicTestsDataDrivenTest {

    @TestFactory
    Stream<DynamicTest> dataDrivenTests() {
        Map<String, String> data = loadDynamicData();
        return data.entrySet()
                   .stream()
                   .map(e -> DynamicTest.dynamicTest(
                           e.getKey(),
                           () -> assertEquals(3, e.getValue().length())));
    }

    private static Map<String, String> loadDynamicData() {
        //simulate loading data dynamically
        return Map.of("A", "one", "B", "two");
    }
}