package com.logicbig.example.engine;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

final class DirectoryScanner {

    private DirectoryScanner() {
    }

    static Set<Class<?>> scan(
            URL packageUrl,
            String basePackage,
            Class<?> targetType
    ) {

        Set<Class<?>> result = new HashSet<>();

        if (!"file".equals(packageUrl.getProtocol())) {
            return result;
        }

        File directory = toDirectory(packageUrl);
        if (directory == null || !directory.exists()) {
            return result;
        }

        scanDirectory(
                directory,
                basePackage,
                targetType,
                result
        );

        return result;
    }

    private static void scanDirectory(
            File directory,
            String packageName,
            Class<?> targetType,
            Set<Class<?>> result
    ) {

        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }

        for (File file : files) {

            if (file.isDirectory()) {
                scanDirectory(
                        file,
                        packageName + "." + file.getName(),
                        targetType,
                        result
                );
                continue;
            }

            if (!file.getName().endsWith(".class")) {
                continue;
            }

            String className =
                    packageName + '.'
                            + file.getName().replace(".class", "");

            try {
                Class<?> candidate =
                        Class.forName(className, false,
                                Thread.currentThread()
                                        .getContextClassLoader());

                if (targetType.isAssignableFrom(candidate)) {
                    result.add(candidate);
                }

            } catch (Throwable ignored) {
            }
        }
    }

    private static File toDirectory(URL url) {
        try {
            String decoded =
                    URLDecoder.decode(
                            url.getPath(),
                            StandardCharsets.UTF_8
                                    .name()
                    );
            return new File(decoded);
        } catch (Exception ex) {
            return null;
        }
    }
}