package com.logicbig.example.engine;

import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public class CustomTestDescriptor extends AbstractTestDescriptor {

    private final Object testInstance;

    public CustomTestDescriptor(
            UniqueId uniqueId,
            String displayName,
            Object testInstance
    ) {
        super(uniqueId, displayName);
        this.testInstance = testInstance;
    }

    public Object getTestInstance() {
        return testInstance;
    }

    @Override
    public Type getType() {
        return Type.TEST;
    }
}