package com.logicbig.example.engine;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public final class ClasspathScanner {

    private ClasspathScanner() {}

    public static Set<Class<?>> findImplementations(
            String basePackage,
            Class<?> targetType
    ) {

        Set<Class<?>> result = new HashSet<>();
        String path = basePackage.replace('.', '/');

        try {
            var resources =
                    Thread.currentThread()
                            .getContextClassLoader()
                            .getResources(path);

            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                result.addAll(
                        DirectoryScanner.scan(
                                url,
                                basePackage,
                                targetType
                        )
                );
            }
        } catch (IOException ignored) {
        }

        return result;
    }
}