package com.logicbig.example;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalTime;

@Component
public class MyBean {

    @Scheduled(initialDelayString = "${initial-delay}",
            fixedDelayString = "${fixed-delay}")
    public void runTask() {
        System.out.printf("Running scheduled task1 " +
                        " thread: %s, time: %s%n",
                Thread.currentThread().getName(),
                LocalTime.now());
    }

    @Scheduled(initialDelayString = "${initial-delay}",
            fixedRateString = "${fixed-rate}")
    public void runTask2() {
        System.out.printf("Running scheduled task2 " +
                        " thread: %s, time: %s%n",
                Thread.currentThread().getName(),
                LocalTime.now());
    }

    @Scheduled(cron = "${cron-expression}")
    public void runTask3() {
        System.out.printf("Running scheduled task3 " +
                        " thread: %s, time: %s%n",
                Thread.currentThread().getName(),
                LocalTime.now());
    }
}