package com.logicbig.example;

import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ConcurrentTaskExecutor;

import java.lang.reflect.Method;
import java.util.concurrent.*;

@EnableAsync
@ComponentScan
public class AsyncConfigurerExample implements AsyncConfigurer {

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        AnnotationConfigApplicationContext context =
                new AnnotationConfigApplicationContext(
                        AsyncConfigurerExample.class);
        MyBean bean = context.getBean(MyBean.class);
        System.out.printf("calling MyBean#runTask() thread: %s%n",
                Thread.currentThread().getName());
        bean.runTask();

        Thread.sleep(3000);
        System.out.println("-- shutting down --");
        System.exit(0);
    }

    @Override
    public Executor getAsyncExecutor() {
        return new ConcurrentTaskExecutor(
                Executors.newFixedThreadPool(1));
    }

    @Override
    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (throwable, method, objects) -> {
            System.out.println("-- exception handler -- " + throwable);
        };
    }
}