package com.logicbig.example;

import com.logicbig.example.beans.Account;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import jakarta.annotation.PostConstruct;
import java.util.Set;

@Configuration
@ComponentScan(basePackages = "com.logicbig.example.beans")
public class InjectingSetOfBeansExample {

    @Bean
    public TestBean testBean() {
        return new TestBean();
    }

    private static class TestBean {
        @Autowired
        @Qualifier("basicAccount")
        private Set<Account> accounts;

        @PostConstruct
        public void init() {
            System.out.println(accounts);
        }
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(
                InjectingSetOfBeansExample.class);
    }
}